﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Xml.Serialization;
using System.IO;
using System.Data.Odbc;

namespace PsgServer
{
    public class DefaultDataTable
    {
        #region Fields / Constructors

        SqlConnection sqlcon;
        Server server;

        public DefaultDataTable()
        {           
            server = Utils.server;
            sqlcon = server.sqlcon;
        }

        #endregion

        public void Load(string nameEntity, string fieldKeyEntity,  object[] param, string outFileName)
        {
            DataTable dt = new DataTable(nameEntity);
            sqlcon.sqlcommand = string.Format("select * from {0} where {1} = {2} or 'null' = {2} ", nameEntity, fieldKeyEntity, param[0]);
            sqlcon.filters(param, 1);

            sqlcon.cmd.CommandText = sqlcon.sqlcommand;
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;

            try
            {                
                sqlcon.Open();
                sqlcon.adapter.Fill(dt);
            }
            catch(Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }

            dt.WriteXmlSchema(outFileName + ".xsd");
            XmlSerializer ser = new XmlSerializer(typeof(DataTable));
            TextWriter writer = new StreamWriter(outFileName + ".xml");
            ser.Serialize(writer, dt);
            writer.Close();
        }

        public void LoadEntity(string nameEntity, string cmd, object[] param, string outFileName)
        {
            DataTable dt = new DataTable(nameEntity);
            sqlcon.sqlcommand = cmd;

            sqlcon.cmd.CommandText = sqlcon.sqlcommand;
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;

            try
            {
                sqlcon.Open();
                sqlcon.adapter.Fill(dt);
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }

            dt.WriteXmlSchema(outFileName + ".xsd");
            XmlSerializer ser = new XmlSerializer(typeof(DataTable));
            TextWriter writer = new StreamWriter(outFileName + ".xml");
            ser.Serialize(writer, dt);
            writer.Close();
        }

        public void Save(string fileXmlEntity)
        {
            DataTable dt = new DataTable();

            XmlSerializer xmlSerializer = new XmlSerializer(typeof(DataTable));
            FileStream readStream = new FileStream(Server.SqlDirectory + fileXmlEntity.ToString() + ".xml", FileMode.Open);    
            dt = (DataTable)xmlSerializer.Deserialize(readStream);
            readStream.Close();

            sqlcon.cmd.CommandText = "select * from " + dt.TableName;
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
            new OdbcCommandBuilder(sqlcon.adapter);

            try
            {
                sqlcon.Open();
                sqlcon.adapter.Update(dt);
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }
        }
    }
}
